<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-calendar-event me-2"></i>Kelola Aktivitas Harian
    </h2>
    <a href="<?= base_url('admin/activities/create') ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle me-1"></i>Tambah Aktivitas
    </a>
</div>

<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle me-2"></i><?= session()->getFlashdata('success') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="bi bi-exclamation-triangle me-2"></i><?= session()->getFlashdata('error') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<!-- Search and Filter Section -->
<div class="admin-card">
    <form method="GET" action="<?= base_url('admin/activities') ?>" class="row g-3">
        <div class="col-md-3">
            <label for="search" class="form-label">Cari Aktivitas</label>
            <input type="text" class="form-control" id="search" name="search" 
                   value="<?= esc($search) ?>" placeholder="Cari nama aktivitas...">
        </div>
        <div class="col-md-2">
            <label for="tanggal_dari" class="form-label">Dari Tanggal</label>
            <input type="date" class="form-control" id="tanggal_dari" name="tanggal_dari" 
                   value="<?= esc($filter['tanggal_dari']) ?>">
        </div>
        <div class="col-md-2">
            <label for="tanggal_sampai" class="form-label">Sampai Tanggal</label>
            <input type="date" class="form-control" id="tanggal_sampai" name="tanggal_sampai" 
                   value="<?= esc($filter['tanggal_sampai']) ?>">
        </div>
        <div class="col-md-2">
            <label for="sort" class="form-label">Sort By</label>
            <select class="form-select" id="sort" name="sort">
                <option value="tanggal" <?= $sort === 'tanggal' ? 'selected' : '' ?>>Tanggal</option>
                <option value="jam" <?= $sort === 'jam' ? 'selected' : '' ?>>Jam</option>
                <option value="nama_aktivitas" <?= $sort === 'nama_aktivitas' ? 'selected' : '' ?>>Nama Aktivitas</option>
                <option value="created_at" <?= $sort === 'created_at' ? 'selected' : '' ?>>Tanggal Dibuat</option>
            </select>
        </div>
        <div class="col-md-2">
            <label for="order" class="form-label">Order</label>
            <select class="form-select" id="order" name="order">
                <option value="ASC" <?= $order === 'ASC' ? 'selected' : '' ?>>ASC</option>
                <option value="DESC" <?= $order === 'DESC' ? 'selected' : '' ?>>DESC</option>
            </select>
        </div>
        <div class="col-md-1 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">
                <i class="bi bi-funnel"></i>
            </button>
        </div>
    </form>
</div>

<!-- Activities Table -->
<div class="admin-card">
    <?php if (empty($activities)): ?>
        <div class="alert alert-info text-center">
            <i class="bi bi-info-circle me-2"></i>Tidak ada aktivitas yang ditemukan.
        </div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>
                            <a href="<?= base_url('admin/activities?sort=tanggal&order=' . ($sort === 'tanggal' && $order === 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search)) ?>" 
                               class="text-white text-decoration-none">
                                Tanggal <i class="bi bi-arrow-down-up"></i>
                            </a>
                        </th>
                        <th>
                            <a href="<?= base_url('admin/activities?sort=jam&order=' . ($sort === 'jam' && $order === 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search)) ?>" 
                               class="text-white text-decoration-none">
                                Jam <i class="bi bi-arrow-down-up"></i>
                            </a>
                        </th>
                        <th>
                            <a href="<?= base_url('admin/activities?sort=nama_aktivitas&order=' . ($sort === 'nama_aktivitas' && $order === 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search)) ?>" 
                               class="text-white text-decoration-none">
                                Nama Aktivitas <i class="bi bi-arrow-down-up"></i>
                            </a>
                        </th>
                        <th>Foto</th>
                        <th>Video</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $no = ($pager->getCurrentPage() - 1) * 10 + 1; ?>
                    <?php foreach ($activities as $activity): ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td><?= date('d/m/Y', strtotime($activity['tanggal'])) ?></td>
                            <td><?= date('H:i', strtotime($activity['jam'])) ?></td>
                            <td><?= esc($activity['nama_aktivitas']) ?></td>
                            <td>
                                <?php if ($activity['foto']): ?>
                                    <img src="<?= image_url('activities', $activity['foto'], 50, 50) ?>" 
                                         alt="Foto Aktivitas" 
                                         class="table-image"
                                         onclick="showImageModal('<?= assets_image_url('activities', $activity['foto']) ?>', 'Foto Aktivitas')"
                                         onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                                    <div style="display: none; width: 50px; height: 50px; background: rgba(255,255,255,0.1); border-radius: 5px; align-items: center; justify-content: center; color: rgba(255,255,255,0.5); font-size: 20px;">📷</div>
                                <?php else: ?>
                                    <span class="text-white">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($activity['video']): ?>
                                    <button class="btn btn-sm btn-outline-success" 
                                            onclick="showVideoModal('<?= assets_image_url('activities', $activity['video']) ?>', '<?= esc($activity['nama_aktivitas']) ?>')">
                                        <i class="bi bi-play-circle me-1"></i>Play
                                    </button>
                                <?php else: ?>
                                    <span class="text-white">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?= base_url('admin/activities/edit/' . $activity['id']) ?>" 
                                   class="btn btn-sm btn-warning btn-action">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <a href="<?= base_url('admin/activities/delete/' . $activity['id']) ?>" 
                                   class="btn btn-sm btn-danger btn-action"
                                   onclick="return confirm('Yakin ingin menghapus aktivitas ini?')">
                                    <i class="bi bi-trash"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <!-- Debug Info -->
        <?php 
        $totalItems = $total ?? $pager->getTotal() ?? count($activities);
        $currentPage = $pager->getCurrentPage() ?? 1;
        $lastPage = ceil($totalItems / 10);
        $hasMore = $totalItems > ($currentPage * 10);
        ?>
        
        <!-- Always show pagination info for debugging -->
        <div class="mt-3 text-center">
            <small class="text-white">
                Debug: Total: <?= $totalItems ?> | Current: <?= $currentPage ?> | Last: <?= $lastPage ?> | HasMore: <?= $hasMore ? 'Yes' : 'No' ?> | Activities: <?= count($activities) ?>
            </small>
        </div>
        
        <?php if ($totalItems > 10): ?>
            <nav aria-label="Page navigation" class="mt-4">
                <ul class="pagination admin-pagination justify-content-center">
                    <?php if ($currentPage > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= base_url('admin/activities?page=' . ($currentPage - 1) . '&search=' . urlencode($search) . '&tanggal_dari=' . urlencode($filter['tanggal_dari']) . '&tanggal_sampai=' . urlencode($filter['tanggal_sampai']) . '&sort=' . $sort . '&order=' . $order) ?>" title="Halaman Sebelumnya">
                                <i class="bi bi-chevron-left"></i> Sebelumnya
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php for ($i = 1; $i <= $lastPage; $i++): ?>
                        <li class="page-item <?= $i == $currentPage ? 'active' : '' ?>">
                            <a class="page-link" href="<?= base_url('admin/activities?page=' . $i . '&search=' . urlencode($search) . '&tanggal_dari=' . urlencode($filter['tanggal_dari']) . '&tanggal_sampai=' . urlencode($filter['tanggal_sampai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                <?= $i ?>
                            </a>
                        </li>
                    <?php endfor; ?>
                    
                    <?php if ($currentPage < $lastPage): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= base_url('admin/activities?page=' . ($currentPage + 1) . '&search=' . urlencode($search) . '&tanggal_dari=' . urlencode($filter['tanggal_dari']) . '&tanggal_sampai=' . urlencode($filter['tanggal_sampai']) . '&sort=' . $sort . '&order=' . $order) ?>" title="Halaman Selanjutnya">
                                Selanjutnya <i class="bi bi-chevron-right"></i>
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
                
                <!-- Pagination Info -->
                <div class="text-center mt-3">
                    <small class="text-white">
                        Menampilkan <?= ($currentPage - 1) * 10 + 1 ?> - <?= min($currentPage * 10, $totalItems) ?> 
                        dari <?= $totalItems ?> aktivitas
                    </small>
                </div>
            </nav>
        <?php else: ?>
            <div class="text-center mt-3">
                <small class="text-white">
                    Menampilkan semua <?= $totalItems ?> aktivitas
                </small>
            </div>
        <?php endif; ?>
    <?php endif; ?>
</div>
<?= $this->endSection() ?>

